// Jasmine Unit Testing Suite
define([
    'backbone',
    'models/external-links-collection',
],
function (Backbone, ExternalLinks) {
    'use strict';

    describe('External Links', function () {
        var resources;

        beforeEach(function () {
            resources = new ExternalLinks();
        });

        it('parses links', function () {
            resources.set({
                'links': [
                    {
                        'id': 'medline-plus',
                        'title': 'MedlinePlus',
                        'href': 'https://vsearch.nlm.nih.gov/vivisimo/cgi-bin/query-meta?v%3Aproject=medlineplus&v%3Asources=medlineplus-bundle&query={keywords}',
                        'keyword-separator': '+',
                    },
                    {
                        'id': 'trm',
                        'title': 'One-VA Technical Reference Model',
                        'href': 'www.DOMAIN.EX/trm/',
                    },
                ],
            }, {parse: true});

            expect(resources.length).toEqual(2);
            expect(resources.get('trm').get('title')).toEqual('One-VA Technical Reference Model');
        });
    });
});
T